/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "myriexpress.h"
#include "test_common.h"

int
main(void)
{
  mx_return_t r;
  uint32_t nic_count;
  uint64_t *nic_ids;
  mx_endpoint_t *endpoints;
  uint32_t ep_count;
  int i, j;

  mx_init();
  mx_set_error_handler(MX_ERRORS_RETURN);

  r = mx_get_info(NULL, MX_NIC_COUNT, NULL, 0, &nic_count, sizeof (nic_count));
  insist(r == MX_SUCCESS);

  nic_ids = malloc ((nic_count+1) * sizeof (*nic_ids));
  insist(nic_ids != NULL);

  r = mx_get_info(NULL, MX_NIC_IDS, NULL, 0, nic_ids, (nic_count+1) * sizeof (*nic_ids));
  insist(r == MX_SUCCESS);

  r = mx_get_info(NULL, MX_MAX_NATIVE_ENDPOINTS, NULL, 0, &ep_count, sizeof (ep_count));
  insist(r == MX_SUCCESS);

  endpoints = malloc (nic_count * ep_count * sizeof (*endpoints));
  insist (endpoints != NULL);

  /* open every endpoint on every nic */
  for (i = 0; i < nic_count; ++i) {
    for (j = 0; j < ep_count; ++j) {
      r = mx_open_endpoint(i, j, 0, NULL, 0,
			   &endpoints[i*ep_count + j]);
      if (r != MX_SUCCESS)
	printf("Error: failed to open endpoint at nic %d:%"PRIx64", endpoint %d. \n  Returned %d ... %s\n", 
	       i, nic_ids[i], j, r, mx_strerror(r));
      insist(r == MX_SUCCESS);
      if (r != MX_SUCCESS) {
	endpoints[i*ep_count + j] = NULL;
      }
    }
  }

  /* try it again, should fail */
  for (i = 0; i < nic_count; ++i) {
    for (j = 0; j < ep_count; ++j) {
      if (endpoints[i*ep_count + j] != NULL) {
	r = mx_open_endpoint(i, j, 0, NULL, 0,
			     &endpoints[i*ep_count + j]);
	insist(r != MX_SUCCESS);
      }
    }
  }

  /* close them all */
  for (i = 0; i < nic_count; ++i) {
    for (j = 0; j < ep_count; ++j) {
      if (endpoints[i*ep_count + j] != NULL) {
	r = mx_close_endpoint(endpoints[i*ep_count + j]);
	insist(r == MX_SUCCESS);
      }
    }
  }

  /* now it should succeed */
  for (i = 0; i < nic_count; ++i) {
    for (j = 0; j < ep_count; ++j) {
      r = mx_open_endpoint(i, j, 0, NULL, 0,
			   &endpoints[i*ep_count + j]);
      if (r != MX_SUCCESS)
	printf("Error: fail to re-open endpoint at nic %d:%"PRIx64", endpoint %d\n  Returned %d ... %s\n", 
	       i, nic_ids[i], j, r, mx_strerror(r));
      insist(r == MX_SUCCESS);
      if (r != MX_SUCCESS) {
	endpoints[i*ep_count + j] = NULL;
      }
    }
  }

  /* close them again */
  for (i = 0; i < nic_count; ++i) {
    for (j = 0; j < ep_count; ++j) {
      if (endpoints[i*ep_count + j] != NULL) {
	r = mx_close_endpoint(endpoints[i*ep_count + j]);
	insist(r == MX_SUCCESS);
      }
    }
  }
  
  free(endpoints);
  free(nic_ids);

  mx_finalize();
  printf("[PASS]\n");
  fflush(stdout);
  return 0;
}
